module net.BurtonRadons.dig.platform.comboBox;

private import net.BurtonRadons.dig.platform.control;
//private import std.string;

//private import std.c.windows.windows;


/** A combination editor widget, also known as a drop-down box.
  */

class ComboBox : Control
{
    private import net.BurtonRadons.dig.platform.base;
    
    Dispatcher onChange; /**< Notified when the current value is changed.  The keyCode field is filled with the name of the entry. */

    /** Register with the parent and create the combo box. */
    this (Control parent)
    {
        super (parent);
        digPlatformStyle |= WS_VISIBLE | WS_CHILD | CBS_DROPDOWNLIST;
        digPlatformHWNDCreate (0, "COMBOBOX", null, digPlatformStyle, (_HANDLE) 0);
        digPlatformSuggestWidth = 100;
        digPlatformSuggestHeight = 25;
        digPlatformMoved ();
    }

    /** Add an item and return the dispatcher called when executing it. */
    Dispatcher *add (char [] name, char [] string)
    {
        Dispatcher d;
        _DWORD index;

        index = SendMessageA (digPlatformHWND, CB_ADDSTRING, 0, (_LPARAM) std.string.toStringz (string));
        SendMessageA (digPlatformHWND, CB_SETITEMDATA, index, index);
        digPlatformItems [index] = d;
        if (name !== null)
            digPlatformNames [name] = index;
        return &digPlatformItems [index];
    }

    /** Add an item and return the dispatcher called when executing it. */
    Dispatcher *add (char [] string)
    {
        return add(null, string);
    }

    /** Add an item, add a dispatcher command, and return the dispatcher. */
    Dispatcher *add (char [] name, char [] string, Dispatcher.Method method)
    {
        Dispatcher *dispatcher;
        
        dispatcher = add(name, string);
        dispatcher.add(method);
        return dispatcher;
    }

    /** Add an item, add a dispatcher command, and return the dispatcher. */
    Dispatcher *add (char [] name, char [] string, Dispatcher.MethodB method)
    {
        Dispatcher *dispatcher;
        
        dispatcher = add(name, string);
        dispatcher.add(method);
        return dispatcher;
    }

    /** Add an item, add a dispatcher command, and return the dispatcher. */
    Dispatcher *add (char [] string, Dispatcher.Method method)
    {
        return add(null, string, method);
    }

    /** Add an item, add a dispatcher command, and return the dispatcher. */
    Dispatcher *add (char [] string, Dispatcher.MethodB method)
    {
        return add(null, string, method);
    }

    /** Clear all items out of the combo box. */
    void empty ()
    {
        for (int c; c < digPlatformItems.keys.length; c ++)
            SendMessageA (digPlatformHWND, CB_DELETESTRING, 0, 0);
        this.digPlatformItems = null;
        this.digPlatformNames = null;
    }

    /** Set the current item. */
    void current (char [] name)
    {
        SendMessageA (digPlatformHWND, CB_SETCURSEL, digPlatformNames [name], 0);
    }

    /** Get the name (or number) of the current selection or null if there is none. */
    char [] current ()
    {
        int index = SendMessageA (digPlatformHWND, CB_GETCURSEL, 0, 0);
        static char [64] buffer;
        int length;

        if (index < 0)
            return null;

        char [] [] keys = digPlatformNames.keys;

        for (int c; c < keys.length; c ++)
            if (digPlatformNames [keys [c]] == index)
                return keys [c];

        length = std.c.stdio.sprintf (buffer, "(%d)", index);
        return buffer [0 .. length];
    }

    /** Set the current item and notify it. */
    void currentAndNotify (char [] name)
    {
        current (name);
        notify (name);
    }

    /** Notify an item without changing the current item. */
    void notify (char [] name)
    {
        digPlatformItems [digPlatformNames [name]].notify ();
    }

    /** Return whether this named item is within the combo box. */
    bit hasItem (char [] name)
    {
        return name in digPlatformNames;
    }

    /** Set whether this is active (true) or grayed and inactive (false). */
    void enabled (bit value)
    {
        EnableWindow (digPlatformHWND, value);
    }

/+
#ifndef DOXYGEN_SHOULD_SKIP_THIS
+/

protected:
    Dispatcher [_DWORD] digPlatformItems; /* Items and their dispatchers. */
    _DWORD [char []] digPlatformNames; /* Names and their items. */

    override void digPlatformMoved ()
    {
        digPlatformDirty = true;
    }

    override void digPlatformSetDimensions (int oldx, int oldy)
    {
        MoveWindow (digPlatformHWND, left (), top (), width (), 200, false);
        //MoveWindow (c.hwnd, c.left (), c.top (), c.width (), c.height (), false);
    }

    override void digPlatformCommand (int code, int id)
    {
        switch (code)
        {
            case CBN_SELCHANGE:
            {
                int result = SendMessageA (digPlatformHWND, CB_GETCURSEL, 0, 0);
                Event e;

                if (result < 0)
                    return;
                digPlatformItems [result].notify ();
                for (int c; c < digPlatformNames.values.length; c ++)
                    if (digPlatformNames.values [c] == result)
                    {
                        e.keyCode = digPlatformNames.keys [c];
                        break;
                    }

                onChange.notify (e);
                return;
            }

            default:
                //printf ("not handled: %d %d\n", code, id);
        }
    }

/+
#endif
+/
}
